ORCA/M Asm65816 2.1.0

0001 B8F4                       title 'Super Controls' 
0002 B8F4              **********************************************************************
0003 B8F4              *
0004 B8F4              *           Copyright Apple Computer, Inc. 1986-89
0005 B8F4              *                    All rights reserved
0006 B8F4              *
0007 B8F4              *
0008 B8F4              * New Calls Supporting Super Controls
0009 B8F4              *
0010 B8F4              * Change History
0011 B8F4              *
0012 B8F4              * 23 Nov 88         Steven Glass
0013 B8F4              *
0014 B8F4              * Changed GetCtlHandleFromID to take a window pointer as input
0015 B8F4              * so this call could be used for controls outside the active window.
0016 B8F4              *
0017 B8F4              * 15 Feb 89         Harry Yee
0018 B8F4              *
0019 B8F4              * Changed MakeNextControlActive and MakeThisCtlActive to first check
0020 B8F4              * if the control is visible or not before making it active.
0021 B8F4              * BRC #41247, 41246 (caused problems with invisible Line Edit controls)
0022 B8F4              *
0023 B8F4              **********************************************************************
0024 B8F4                       Blanks off 
0025 B8F4                       String asis 
0026 B8F4
0027 B8F4
0028 B8F4
0029 B8F4              ;-----------------------------------------------------------
0030 B8F4              ;
0031 B8F4              ; Include Equate and macro files
0032 B8F4              ;
0033 B8F4              ; All.macros
0034 B8F4              ; equates.asm
0035 B8F4              ; superequates.asm
0036 B8F4              ;
0037 B8F4                       print push 
0038 B8F4                       print off 
0039 B8F4
0040 B8F4
0041 B8F4                       INCLUDE 'all.macros' 
0042 B8F4
0043 B8F4                       include 'equates.asm' 
0044 B8F4                       include 'SuperEquates.asm' 
0045 B8F4
0046 B8F4              ;-----------------------------------------------------------
0047 B8F4              ;
0048 B8F4              ; Global Imports
0049 B8F4              ;
0050 B8F4                       import CMpop0bytes 
0051 B8F4                       import CMpop4bytes 
0052 B8F4                       import CMpop6bytes 
0053 B8F4                       import CMpop8bytes 
0054 B8F4                       import CMpop10bytes 
0055 B8F4                       import CMpop12bytes 
0056 B8F4
0057 B8F4                       print pop 
0058 B8F4
0059 B8F4
0060 B8F4                       title 'FindActiveControl' 
0061 B8F4              ****************************************************************
0062 B8F4              *
0063 B8F4              FindActiveControl PROC EXPORT 
0064 B8F4              *
0065 B8F4              * This routine returns the handle to the active 
0066 B8F4              * super control.  A number of errors can be returned:
0067 B8F4              *
0068 B8F4              *   NOWIND_Err
0069 B8F4              *   NoCtlError
0070 B8F4              *   NoSuperCtlError
0071 B8F4              *   NoCtlActiveError
0072 B8F4              *
0073 B8F4              * Note:  This call only works with the front window.
0074 B8F4              *
0075 B8F4              *
0076 B8F4              * Inputs:
0077 B8F4              *                   none
0078 B8F4              *
0079 B8F4              * Outputs:
0080 B8F4              *                   ControlHandle
0081 B8F4              *
0082 B8F4              * External Refs:
0083 B8F4                       import CMStartup 
0084 B8F4                       import FindActiveGuts2 
0085 B8F4              *
0086 B8F4              * Entry Points:
0087 B8F4              *                   none
0088 B8F4              *
0089 B8F4                       longa on                       ; mode
0090 B8F4                       longi on
0091 B8F4              *
0092 B8F4              ****************************************************************
0093 B8F4
0094 B8F4
0095 B8F4              ResultH  equ   Inputs
0096 B8F4
0097 B8F4 20 15 A0              jsr   CMStartup                ; link things in and start things up.
0098 B8F7
0099 B8F7 64 4E                 stz   ResultH
0100 B8F9 64 50                 stz   ResultH+2
0101 B8FB
0102 B8FB 20 DE BB              jsr   FindActiveGuts2
0103 B8FE B0 08                 bcs   Done
0104 B900
0105 B900 A5 01                 lda   ctlHand                  ; move result into place
0106 B902 85 4E                 sta   ResultH
0107 B904 A5 03                 lda   ctlHand+2
0108 B906 85 50                 sta   ResultH+2
0109 B908
0110 B908 82 67 E7     Done     brl   CMpop0Bytes
0111 B90B
0112 B90B
0113 B90B
0114 B90B                       ENDP 
0115 B90B
0116 B90B
0117 B90B
0118 B90B
0119 B90B
0120 B90B                       title 'MakeNextControlActive' 
0121 B90B              ****************************************************************
0122 B90B              *
0123 B90B              MakeNextControlActive PROC EXPORT  
0124 B90B              *
0125 B90B              * This routine returns the handle to the newly activated
0126 B90B              * super control.  A number of errors can be returned:
0127 B90B              *
0128 B90B              *   NOWIND_Err
0129 B90B              *   NoCtlError
0130 B90B              *   NoSuperCtlError
0131 B90B              *   NoCtlToBeActiveError
0132 B90B              *
0133 B90B              * The newly activated control and the newly deactivated
0134 B90B              * control are both sent activation messages so that
0135 B90B              * they can change their display.
0136 B90B              *
0137 B90B              * This routine has the strange ability to return the
0138 B90B              * same control as was originally active.  When this
0139 B90B              * happens, no activation messages are sent.
0140 B90B              *
0141 B90B              * Note:  This call only works on the front window.
0142 B90B              *
0143 B90B              * Inputs:
0144 B90B              *                   none
0145 B90B              *
0146 B90B              * Outputs:
0147 B90B              *                   ControlHandle
0148 B90B              *
0149 B90B              * External Refs:
0150 B90B                       import CMStartup 
0151 B90B                       import FindActiveGuts2 
0152 B90B                       import GetFirstSuperControl 
0153 B90B                       import GetNextSuperControl 
0154 B90B                       import CallIt 
0155 B90B                       import CMDispatch 
0156 B90B              *
0157 B90B              * Entry Points:
0158 B90B              *                   none
0159 B90B              *
0160 B90B                       longa on                       ; mode
0161 B90B                       longi on
0162 B90B              *
0163 B90B              ****************************************************************
0164 B90B              ResultH  equ   Inputs
0165 B90B
0166 B90B                       import dereference 
0167 B90B
0168 B90B 20 15 A0              jsr   CMStartup                ; link things in and start things up.
0169 B90E
0170 B90E 64 2D                 stz   work                     ; indicate that this is the first time in
0171 B910
0172 B910 64 4E                 stz   ResultH
0173 B912 64 50                 stz   ResultH+2
0174 B914
0175 B914 20 DE BB              jsr   FindActiveGuts2          ; get first active control in  
0176 B917 90 08                 bcc   GotActive                ; front window.
0177 B919
0178 B919 F4 00 00 F4           PushLong #0                    ; nothing active, put 0 on stack
0179 B91F 80 44                 bra   TryFirst
0180 B921
0181 B921 D4 03        GotActive pei   CtlHand+2               ; this is the control that needs to
0182 B923 D4 01                 pei   CtlHand                  ; be made inactive
0183 B925
0184 B925 A0 3C 00              ldy   #NewCtlRecord.CtlMoreFlags ; Clear current active bit
0185 B928 B7 05                 lda   [<CtlPtr],y
0186 B92A 29 FF 7F              and   #($FFFF-FCtlActive)
0187 B92D 97 05                 sta   [<CtlPtr],y
0188 B92F
0189 B92F 20 A6 BB     Again    jsr   GetNextSuperControl      ; find next control that can be made active
0190 B932 B0 31                 bcs   TryFirst                 ; no more, so start back
0191 B934
0192 B934              ;
0193 B934              ; --- Got next super control -----------------------------------------------------------------------
0194 B934              ;
0195 B934              TryThis   
0196 B934 A0 3C 00              ldy   #NewCtlRecord.CtlMoreFlags ; can this be active?
0197 B937 B7 05                 lda   [<CtlPtr],y
0198 B939 29 00 40              and   #FCtlCanBeActive
0199 B93C F0 F1                 beq   Again                    ; no, go on
0200 B93E
0201 B93E A0 10 00              ldy   #NewCtlRecord.CtlFlag    ; check if its visible or not
0202 B941 B7 05                 lda   [<CtlPtr],y
0203 B943 89 80 00              bit   #$0080
0204 B946 D0 E7                 bne   Again                    ; no, go on
0205 B948
0206 B948 A0 3C 00     useThisControl ldy   #NewCtlRecord.CtlMoreFlags ; make it active
0207 B94B B7 05                 lda   [<CtlPtr],y
0208 B94D 09 00 80              ora   #FCtlActive
0209 B950 97 05                 sta   [<CtlPtr],y
0210 B952
0211 B952 A5 01                 lda   ctlHand                  ; return result
0212 B954 85 4E                 sta   ResultH
0213 B956 A5 03                 lda   ctlHand+2
0214 B958 85 50                 sta   ResultH+2
0215 B95A
0216 B95A 20 77 B9              jsr   Notify2                  ; notify control that is being deact. and
0217 B95D              ;                                       ; the one being made active, 
0218 B95D              ;                                       ; deact. control is on stack, active 
0219 B95D              ;                                       ; control is in ctlhand
0220 B95D A0 00 00     NoError  ldy   #0
0221 B960 68           exit     pla                            ; clear the stack
0222 B961 68                    pla   
0223 B962 82 0D E7              brl   CMpop0Bytes
0224 B965
0225 B965
0226 B965 A5 2D        TryFirst lda   <Work                    ; see if we've been here before
0227 B967 D0 09                 bne   Oops
0228 B969 C6 2D                 dec   <Work                    ; mark that we are here
0229 B96B 20 9C BB              jsr   GetFirstSuperControl
0230 B96E 90 C4                 bcc   TryThis
0231 B970
0232 B970 80 EE                 bra   exit
0233 B972
0234 B972 A0 0B 10     Oops     ldy   #NoCtlToBeActiveError
0235 B975 80 E9                 bra   exit
0236 B977
0237 B977
0238 B977              ;-----------------------------------------------------------
0239 B977              ;
0240 B977              ; This is the entry point for notifying two controls
0241 B977              ; that their status changed.
0242 B977              ;
0243 B977              ; The control that was deactivated is on the stack.
0244 B977              ; The control that was activated is in ctlHand
0245 B977              ;
0246 B977              ; This routine does not alter the stack.
0247 B977              ;
0248 B977                       ENTRY Notify2
0249 B977              Notify2   
0250 B977                       DefineStack 
0251 B977              RTSAddr  word 
0252 B977              OldHandle long 
0253 B977
0254 B977 A5 01                 lda   ctlHand
0255 B979 C3 03                 cmp   OldHandle,s
0256 B97B D0 06                 bne   NotSame
0257 B97D A5 03                 lda   ctlHand+2
0258 B97F C3 05                 cmp   OldHandle+2,s
0259 B981 F0 16                 beq   Same
0260 B983
0261 B983              ;-----------------------------------------------------------
0262 B983              ;
0263 B983              ; The active control changed, so we have to notify
0264 B983              ; the old one and the new one.
0265 B983
0266 B983 A3 05        NotSame  lda   OldHandle+2,s            ; first the old one
0267 B985 AA                    tax   
0268 B986 A3 03                 lda   OldHandle,s
0269 B988 D0 05                 bne   OK                       ; if there was one
0270 B98A E0 00 00              cpx   #0
0271 B98D F0 03                 beq   NoOld
0272 B98F 20 9A B9     OK       jsr   Notify
0273 B992 A6 03        NoOld    ldx   CtlHand+2
0274 B994 A5 01                 lda   CtlHand
0275 B996 20 9A B9              jsr   Notify
0276 B999
0277 B999 60           Same     rts   
0278 B99A
0279 B99A
0280 B99A              Notify    
0281 B99A D4 03                 pei   CtlHand+2                ; save old ctlhand
0282 B99C D4 01                 pei   CtlHand
0283 B99E 86 03                 stx   CtlHand+2                ; put this one in ctlHand
0284 B9A0 85 01                 sta   CtlHand
0285 B9A2
0286 B9A2 A9 00 00              lda   #0
0287 B9A5 A8                    tay   
0288 B9A6 A2 0E 00              ldx   #ctlChangeActivity
0289 B9A9 20 2B 9C              jsr   CMDispatch
0290 B9AC
0291 B9AC 68                    pla                            ; restore CtlHand
0292 B9AD 85 01                 sta   CtlHand
0293 B9AF 68                    pla   
0294 B9B0 85 03                 sta   CtlHand+2
0295 B9B2 60                    rts   
0296 B9B3
0297 B9B3                       ENDP 
0298 B9B3
0299 B9B3
0300 B9B3
0301 B9B3
0302 B9B3
0303 B9B3
0304 B9B3                       title 'MakeThisCtlActive' 
0305 B9B3              ****************************************************************
0306 B9B3              *
0307 B9B3              MakeThisCtlActive PROC EXPORT 
0308 B9B3              *
0309 B9B3              * This routine makes the specified control active
0310 B9B3              *
0311 B9B3              *   NotSuperCtlError
0312 B9B3              *   CannotBeActiveError
0313 B9B3              *
0314 B9B3              *
0315 B9B3              *
0316 B9B3              *
0317 B9B3              * Inputs:
0318 B9B3              *                   TheControl
0319 B9B3              *
0320 B9B3              * Outputs:
0321 B9B3              *                   none
0322 B9B3              *
0323 B9B3              * External Refs:
0324 B9B3                       import CMStartup 
0325 B9B3                       import Dereference 
0326 B9B3                       import IsItSuper 
0327 B9B3                       import Notify2 
0328 B9B3                       import FindActiveGuts 
0329 B9B3                       import UseThisWindPtr 
0330 B9B3              *
0331 B9B3              * Entry Points:
0332 B9B3              *                   none
0333 B9B3              *
0334 B9B3                       longa on                       ; mode
0335 B9B3                       longi on
0336 B9B3              *
0337 B9B3              *
0338 B9B3              * Change History
0339 B9B3              *
0340 B9B3              * 17 Nov 88         Steven Glass
0341 B9B3              *
0342 B9B3              * This routine did not work if the control's window was not
0343 B9B3              * active.  We fix this by getting the control's window pointer
0344 B9B3              * from the control record instead of the window manager.
0345 B9B3              *
0346 B9B3              * Bug was found by opening a window (invisible), calling
0347 B9B3              * NewControl2 for a number lineedit items.  Each item is 
0348 B9B3              * made active with this call, but since we could not find
0349 B9B3              * the window, we could not clear any of the others.
0350 B9B3              *
0351 B9B3              * 15 Feb 89         Harry Yee
0352 B9B3              *
0353 B9B3              * Before making a control active we were not checking to 
0354 B9B3              * see whether it was visible first.
0355 B9B3              *
0356 B9B3              ****************************************************************
0357 B9B3
0358 B9B3
0359 B9B3              TheControl equ   Inputs
0360 B9B3
0361 B9B3 20 15 A0              jsr   CMStartup                ; link things in and start things up.
0362 B9B6
0363 B9B6 A5 4E                 lda   TheControl               ; setup pointer to this control's window.
0364 B9B8 85 01                 sta   ctlHand
0365 B9BA A5 50                 lda   TheControl+2
0366 B9BC 85 03                 sta   ctlHand+2
0367 B9BE 20 E2 A1              jsr   Dereference
0368 B9C1 A0 06 00              ldy   #NewCtlRecord.CtlOwner+2
0369 B9C4 B7 05                 lda   [ctlPtr],y
0370 B9C6 AA                    tax   
0371 B9C7 88                    dey   
0372 B9C8 88                    dey   
0373 B9C9 B7 05                 lda   [ctlPtr],y
0374 B9CB 20 BE BB              jsr   UseThisWindPtr
0375 B9CE
0376 B9CE 20 E3 BB              jsr   FindActiveGuts           ; look for old active 
0377 B9D1 90 08                 bcc   FoundActive
0378 B9D3
0379 B9D3 F4 00 00 F4           PushLong #0                    ; there was no old active
0380 B9D9 80 11                 bra   FixThisOne               ; so put 0 on stack
0381 B9DB
0382 B9DB D4 03        FoundActive pei   ctlHand+2             ; put old active on stack
0383 B9DD D4 01                 pei   ctlHand
0384 B9DF
0385 B9DF 20 E2 A1              jsr   Dereference              ; clear the active bit
0386 B9E2 A0 3C 00              ldy   #NewCtlRecord.CtlMoreFlags
0387 B9E5 B7 05                 lda   [CtlPtr],y
0388 B9E7 29 FF 7F              and   #($FFFF-FCtlActive)
0389 B9EA 97 05                 sta   [CtlPtr],y
0390 B9EC
0391 B9EC              FixThisOne  
0392 B9EC A5 4E                 lda   TheControl               ; move control handle in and deref it
0393 B9EE 85 01                 sta   ctlHand                  ; this is the control that we want to 
0394 B9F0 A5 50                 lda   TheControl+2             ; make active
0395 B9F2 85 03                 sta   ctlHand+2
0396 B9F4
0397 B9F4 20 E2 A1              jsr   Dereference
0398 B9F7
0399 B9F7 20 89 BB              jsr   IsItSuper                ; if it is not super, return error
0400 B9FA B0 26                 bcs   NotSuper
0401 B9FC
0402 B9FC A0 10 00              ldy   #NewCtlRecord.CtlFlag    ; check if the control is visible
0403 B9FF B7 05                 lda   [<CtlPtr],y
0404 BA01 89 80 00              bit   #$0080                   ; check the invisible bit
0405 BA04 D0 21                 bne   NotPossible              ; if set then control is invisible
0406 BA06
0407 BA06 A0 3C 00              ldy   #NewCtlRecord.CtlMoreFlags ; control is visible, now check if it 
0408 BA09 B7 05                 lda   [<CtlPtr],y              ; can be made active
0409 BA0B 29 00 40              and   #FCtlCanBeActive
0410 BA0E F0 17                 beq   NotPossible
0411 BA10
0412 BA10 B7 05                 lda   [<CtlPtr],y              ; make it active
0413 BA12 09 00 80              ora   #FCtlActive
0414 BA15 97 05                 sta   [<CtlPtr],y
0415 BA17
0416 BA17 20 77 B9              jsr   Notify2                  ; let control know that its being made
0417 BA1A              ;                                       ; active
0418 BA1A A0 00 00              ldy   #0                       ; no error
0419 BA1D 68           exit     pla                            ; clean stack
0420 BA1E 68                    pla   
0421 BA1F 82 55 E6              brl   CMpop4Bytes
0422 BA22
0423 BA22 A0 07 10     NotSuper ldy   #NotSuperCtlError        ; error is this is not rt type of control
0424 BA25 80 F6                 bra   Exit
0425 BA27
0426 BA27 A0 08 10     NotPossible ldy   #CanNotBeActiveError  ; error is this cannot be made active
0427 BA2A 80 F1                 bra   Exit                     ; caused by ctlMoreFlags FCtlCanBeActive
0428 BA2C              ;                                       ; bit not set or control is invisible
0429 BA2C
0430 BA2C                       ENDP 
0431 BA2C
0432 BA2C
0433 BA2C
0434 BA2C                       title 'SendEventToControl' 
0435 BA2C              ****************************************************************
0436 BA2C              *
0437 BA2C              SendEventToControl PROC EXPORT 
0438 BA2C              *
0439 BA2C              * This call is used to send events to the active control and to
0440 BA2C              * any *visible* control including the active control.
0441 BA2C              *
0442 BA2C              * If the ActiveOnly flag is TRUE, then only the active control
0443 BA2C              * gets the event.
0444 BA2C              *
0445 BA2C              * If the Active flag is FALSE, then the following takes place.
0446 BA2C              * We perform a two part search for a control to take this event.
0447 BA2C              * First, we look for controls that want key strokes that are 
0448 BA2C              * not edit fields.  Each control is asked to take the event.
0449 BA2C              * If none of these controls wants hte event, the active
0450 BA2C              * edit field is asked to accept the event.
0451 BA2C              *
0452 BA2C              * If no control accepts the event, the output is FALSE.  If 
0453 BA2C              * one of the controls accepts the event, the output is TRUE.
0454 BA2C              * The handle of the accepting control is put into TaskDATA2 and
0455 BA2C              * the ItemID is put in TaskDATA3.
0456 BA2C              *
0457 BA2C              *
0458 BA2C              * Inputs:
0459 BA2C              *                   ActiveOnlyFlag
0460 BA2C              *                   WindowPtr
0461 BA2C              *                   TaskRecPtr
0462 BA2C              *
0463 BA2C              * Outputs:
0464 BA2C              *                   BooleanWord
0465 BA2C              *
0466 BA2C              * External Refs:
0467 BA2C                       import CMStartup 
0468 BA2C                       import UseThisWindPtr 
0469 BA2C                       import GetFirstSuperControl 
0470 BA2C                       import GetNextSuperControl 
0471 BA2C                       import FindActiveGuts 
0472 BA2C                       import CMDispatch 
0473 BA2C              *
0474 BA2C              * Entry Points:
0475 BA2C              *                   none
0476 BA2C              *
0477 BA2C                       longa on                       ; mode
0478 BA2C                       longi on
0479 BA2C              *
0480 BA2C              * Change History
0481 BA2C              *
0482 BA2C              * 04 Nov 88         Steven Glass
0483 BA2C              *
0484 BA2C              * The control ID was returned in the wrong place and the
0485 BA2C              * result from the DefPRoc was not returned at all.
0486 BA2C              *
0487 BA2C              * 17 Nov 88         Steven Glass
0488 BA2C              *
0489 BA2C              * Now use the specified window pointer instead of FrontWindow.
0490 BA2C              *
0491 BA2C              ****************************************************************
0492 BA2C
0493 BA2C
0494 BA2C              TaskRecPtr equ   Inputs
0495 BA2C              WindowPtr equ   TaskRecPtr+4
0496 BA2C              ActiveOnlyFlag equ   WindowPtr+4
0497 BA2C              BooleanResult equ   ActiveOnlyFlag+2
0498 BA2C
0499 BA2C
0500 BA2C 20 15 A0              jsr   CMStartup
0501 BA2F
0502 BA2F 64 58                 stz   BooleanResult            ; assume the worst
0503 BA31
0504 BA31 A5 52                 lda   WindowPtr
0505 BA33 A6 54                 ldx   WindowPtr+2
0506 BA35 20 BE BB              jsr   UseThisWindPtr
0507 BA38 B0 5D                 bcs   exit
0508 BA3A
0509 BA3A A5 56                 lda   ActiveOnlyFlag
0510 BA3C D0 22                 bne   TryActive
0511 BA3E
0512 BA3E 20 9C BB              jsr   GetFirstSuperControl
0513 BA41 B0 54                 bcs   exit
0514 BA43
0515 BA43              Loop      
0516 BA43 A0 3C 00              ldy   #NewCtlRecord.CtlMoreFlags ; if this one can be active, skip it for now
0517 BA46 B7 05                 lda   [<CtlPtr],y
0518 BA48 29 00 40              and   #FCtlCanBeActive
0519 BA4B D0 0E                 bne   SkipThisOne
0520 BA4D
0521 BA4D B7 05                 lda   [<CtlPtr],y              ; if the control does not want events, then
0522 BA4F 29 00 20              and   #FCtlWantEvents          ; we skip it.
0523 BA52 F0 07                 beq   SkipThisOne
0524 BA54
0525 BA54 20 9A BA              jsr   SendIt
0526 BA57
0527 BA57 A5 58                 lda   BooleanResult
0528 BA59 D0 11                 bne   FinishUp
0529 BA5B              SkipThisOne  
0530 BA5B 20 A6 BB              jsr   GetNextSuperControl
0531 BA5E 90 E3                 bcc   Loop
0532 BA60
0533 BA60              TryActive  
0534 BA60 20 E3 BB              jsr   FindActiveGuts
0535 BA63 B0 2F                 bcs   Done
0536 BA65
0537 BA65 20 9A BA              jsr   SendIt
0538 BA68 A5 58                 lda   BooleanResult
0539 BA6A F0 28                 beq   Done
0540 BA6C
0541 BA6C
0542 BA6C              FinishUp  
0543 BA6C              ;
0544 BA6C              ; Return the handle to the control in TaskDATA2
0545 BA6C              ;
0546 BA6C A0 1E 00              ldy   #NewTaskRecord.TaskData2
0547 BA6F A5 01                 lda   ctlHand
0548 BA71 97 4E                 sta   [TaskRecPtr],y
0549 BA73 C8                    iny   
0550 BA74 C8                    iny   
0551 BA75 A5 03                 lda   ctlHand+2
0552 BA77 97 4E                 sta   [TaskRecPtr],y
0553 BA79              ;
0554 BA79              ; Return the result passed by defProc in TaskData3
0555 BA79              ;
0556 BA79 A5 58                 lda   BooleanResult
0557 BA7B A0 22 00              ldy   #NewTaskRecord.TaskData3
0558 BA7E 97 4E                 sta   [<TaskRecPtr],y
0559 BA80              ;
0560 BA80              ; Return the control ID in taskdata4.
0561 BA80              ;
0562 BA80 A0 38 00              ldy   #NewCtlRecord.CtlID
0563 BA83 B7 05                 lda   [CtlPtr],y
0564 BA85 A0 26 00              ldy   #NewTaskRecord.TaskData4
0565 BA88 97 4E                 sta   [<TaskRecPtr],y
0566 BA8A A0 3A 00              ldy   #NewCtlRecord.CtlID+2
0567 BA8D B7 05                 lda   [CtlPtr],y
0568 BA8F A0 28 00              ldy   #NewTaskRecord.TaskData4+2
0569 BA92 97 4E                 sta   [<TaskRecPtr],y
0570 BA94
0571 BA94 A0 00 00     Done     ldy   #0
0572 BA97 82 EC E5     exit     brl   CMpop10Bytes
0573 BA9A
0574 BA9A              ;-----------------------------------------------------------
0575 BA9A              ;
0576 BA9A              ; Local routine to actually call the defproc
0577 BA9A              ;
0578 BA9A
0579 BA9A              SendIt    
0580 BA9A A5 4E                 lda   TaskRecPtr
0581 BA9C A4 50                 ldy   TaskRecPtr+2
0582 BA9E A2 0D 00              ldx   #ctlHandleEvent
0583 BAA1 20 2B 9C              jsr   CMDispatch
0584 BAA4 85 58                 sta   BooleanResult
0585 BAA6
0586 BAA6 60                    rts   
0587 BAA7
0588 BAA7
0589 BAA7                       ENDP 
0590 BAA7
0591 BAA7                       title 'GetHandleFromID' 
0592 BAA7              ****************************************************************
0593 BAA7              *
0594 BAA7              getHandleFromID PROC EXPORT 
0595 BAA7              *
0596 BAA7              * Returns the handle of the control with the specified ID.
0597 BAA7              * This routine only searches the specified window.
0598 BAA7              *
0599 BAA7              *
0600 BAA7              * Inputs:
0601 BAA7              *                   HandleSpace         LONG
0602 BAA7              *                   WindowPtr           LONG
0603 BAA7              *                   ID                  LONG
0604 BAA7              *
0605 BAA7              * Outputs:
0606 BAA7              *                   ControlHandle
0607 BAA7              *
0608 BAA7              * External Refs:
0609 BAA7                       import CMStartup 
0610 BAA7                       import UseThisWindPtr 
0611 BAA7                       import GetFirstSuperControl 
0612 BAA7                       import GetNextSuperControl 
0613 BAA7              *
0614 BAA7              * Entry Points:
0615 BAA7              *                   none
0616 BAA7              *
0617 BAA7                       longa on                       ; mode
0618 BAA7                       longi on
0619 BAA7              *
0620 BAA7              * Change History
0621 BAA7              *
0622 BAA7              * 23 Nov 88         Steven Glass
0623 BAA7              *
0624 BAA7              * Added WindowPtr input so this call can be made for any window.
0625 BAA7              *
0626 BAA7              ****************************************************************
0627 BAA7
0628 BAA7              TheID    equ   Inputs
0629 BAA7              TheWindow equ   TheID+4
0630 BAA7              TheHandle equ   TheWindow+4
0631 BAA7
0632 BAA7 20 15 A0              jsr   CMStartup                Do tool function setup.
0633 BAAA
0634 BAAA 64 56                 stz   <TheHandle               Assume it won't be found
0635 BAAC 64 58                 stz   <TheHandle+2
0636 BAAE
0637 BAAE A5 52                 lda   TheWindow
0638 BAB0 A6 54                 ldx   TheWindow+2
0639 BAB2 20 BE BB              jsr   UseThisWindPtr
0640 BAB5 B0 21                 bcs   exit
0641 BAB7
0642 BAB7 20 9C BB              jsr   GetFirstSuperControl
0643 BABA B0 1C                 bcs   exit
0644 BABC
0645 BABC A0 38 00     Loop     ldy   #NewCtlRecord.CtlID
0646 BABF B7 05                 lda   [<ctlPtr],y
0647 BAC1 C5 4E                 cmp   <TheID
0648 BAC3 D0 16                 bne   Nope
0649 BAC5 C8                    iny   
0650 BAC6 C8                    iny   
0651 BAC7 B7 05                 lda   [<ctlPtr],y
0652 BAC9 C5 50                 cmp   <TheID+2
0653 BACB D0 0E                 bne   Nope
0654 BACD
0655 BACD A5 01                 lda   <ctlHand
0656 BACF 85 56                 sta   <TheHandle
0657 BAD1 A5 03                 lda   <ctlHand+2
0658 BAD3 85 58                 sta   <TheHandle+2
0659 BAD5
0660 BAD5 A0 00 00              ldy   #0
0661 BAD8 82 A6 E5     exit     brl   CMpop8bytes
0662 BADB
0663 BADB 20 A6 BB     nope     jsr   GetNextSuperControl
0664 BADE 90 DC                 bcc   Loop
0665 BAE0
0666 BAE0 A0 09 10              ldy   #NoSuchIDError
0667 BAE3 80 F3                 bra   exit
0668 BAE5
0669 BAE5
0670 BAE5                       ENDP 
0671 BAE5
0672 BAE5
0673 BAE5                       title 'Set and Get CtlID' 
0674 BAE5              ****************************************************************
0675 BAE5              *
0676 BAE5              setCtlID PROC EXPORT 
0677 BAE5              *
0678 BAE5              * Sets CtlID field in control.
0679 BAE5              *
0680 BAE5              *
0681 BAE5              * Inputs:
0682 BAE5              *                   TheID               LONG
0683 BAE5              *                   TheControl          LONG
0684 BAE5              *
0685 BAE5              * Outputs:
0686 BAE5              *                   none
0687 BAE5              *
0688 BAE5              * External Refs:
0689 BAE5                       import CMStartup 
0690 BAE5                       import getCtlHand 
0691 BAE5                       import isItSuper 
0692 BAE5                       import set_long 
0693 BAE5              *
0694 BAE5              * Entry Points:
0695 BAE5              *                   none
0696 BAE5              *
0697 BAE5                       longa on                       ; mode
0698 BAE5                       longi on
0699 BAE5              *
0700 BAE5              ****************************************************************
0701 BAE5
0702 BAE5
0703 BAE5 20 15 A0              jsr   CMStartup                Do tool function setup.
0704 BAE8              ;
0705 BAE8 20 9F A1              jsr   getCtlHand               ctlHand = passed control handle.
0706 BAEB              ;                                       ctlPtr = (ctlHand).
0707 BAEB A0 04 10              ldy   #NoCtlError
0708 BAEE B0 0E                 bcs   pop8                     Null handle passed?
0709 BAF0              ;
0710 BAF0 20 89 BB              jsr   IsItSuper
0711 BAF3 B0 09                 bcs   pop8
0712 BAF5
0713 BAF5 A0 38 00              ldy   #NewCtlRecord.CtlID
0714 BAF8 82 84 D9              brl   Set_LONG
0715 BAFB
0716 BAFB A0 00 00              ldy   #0
0717 BAFE              pop8      
0718 BAFE 82 80 E5              brl   CMpop8bytes
0719 BB01
0720 BB01
0721 BB01                       ENDP 
0722 BB01
0723 BB01
0724 BB01              ****************************************************************
0725 BB01              *
0726 BB01              GetCtlID PROC EXPORT 
0727 BB01              *
0728 BB01              * Returns CtlID field in control.
0729 BB01              *
0730 BB01              *
0731 BB01              * Inputs:
0732 BB01              *                   space for result    LONG
0733 BB01              *                   TheControl          LONG
0734 BB01              *
0735 BB01              * Outputs:
0736 BB01              *                   TheID               LONG
0737 BB01              *
0738 BB01              * External Refs:
0739 BB01                       import CMStartup 
0740 BB01                       import getCtlHand 
0741 BB01                       import isItSuper 
0742 BB01                       import get_long 
0743 BB01                       import pop4 
0744 BB01              *
0745 BB01              * Entry Points:
0746 BB01              *                   none
0747 BB01              *
0748 BB01                       longa on                       ; mode
0749 BB01                       longi on
0750 BB01              *
0751 BB01              ****************************************************************
0752 BB01
0753 BB01
0754 BB01 20 15 A0              jsr   CMStartup                Do tool function setup.
0755 BB04              ;
0756 BB04 20 9F A1              jsr   getCtlHand               ctlHand = passed control handle.
0757 BB07              ;                                       ctlPtr = (ctlHand).
0758 BB07 A0 04 10              ldy   #NoCtlError
0759 BB0A B0 25                 bcs   pop4                     Null handle passed?
0760 BB0C              ;
0761 BB0C 20 89 BB              jsr   IsItSuper
0762 BB0F B0 20                 bcs   pop4
0763 BB11
0764 BB11 A0 38 00              ldy   #NewCtlRecord.CtlID
0765 BB14 82 83 D9              brl   get_long
0766 BB17
0767 BB17
0768 BB17                       ENDP 
0769 BB17
0770 BB17
0771 BB17                       title 'Get and Set MoreFlags' 
0772 BB17              ****************************************************************
0773 BB17              *
0774 BB17              GetCtlMoreFlags PROC EXPORT 
0775 BB17              *
0776 BB17              * Returns the moreflags field of the control record.
0777 BB17              *
0778 BB17              *
0779 BB17              * Inputs:
0780 BB17              *                   WordSpace
0781 BB17              *                   ControlHandle
0782 BB17              *
0783 BB17              * Outputs:
0784 BB17              *                   MoreFlags        WORD
0785 BB17              *
0786 BB17              * External Refs:
0787 BB17                       import CMStartup 
0788 BB17                       import isItSuper 
0789 BB17                       import getCtlHand 
0790 BB17              *
0791 BB17              * Entry Points:
0792 BB17                       entry pop4 
0793 BB17              *
0794 BB17                       longa on                       ; mode
0795 BB17                       longi on
0796 BB17              *
0797 BB17              ****************************************************************
0798 BB17              TheControl equ   Inputs
0799 BB17              ResultFlags equ   TheControl+4
0800 BB17
0801 BB17 20 15 A0              jsr   CMStartup                Do tool function setup.
0802 BB1A              ;
0803 BB1A 20 9F A1              jsr   getCtlHand               ctlHand = passed control handle.
0804 BB1D              ;                                       ctlPtr = (ctlHand).
0805 BB1D A0 04 10              ldy   #NoCtlError
0806 BB20 B0 0F                 bcs   pop4                     Null handle passed?
0807 BB22              ;
0808 BB22 20 89 BB              jsr   IsItSuper
0809 BB25 B0 0A                 bcs   pop4
0810 BB27              ;
0811 BB27 A0 3C 00              ldy   #NewCtlRecord.CtlMoreFlags
0812 BB2A
0813 BB2A B7 05                 lda   [<Ctlptr],y
0814 BB2C 85 52                 sta   <ResultFlags
0815 BB2E              ;
0816 BB2E A0 00 00              ldy   #0                       No error flag.
0817 BB31
0818 BB31
0819 BB31                       entry pop4 
0820 BB31              pop4      
0821 BB31 82 43 E5              brl   CMpop4bytes
0822 BB34              ;
0823 BB34
0824 BB34                       ENDP 
0825 BB34
0826 BB34              ****************************************************************
0827 BB34              *
0828 BB34              SetCtlMoreFlags PROC EXPORT 
0829 BB34              *
0830 BB34              * Sets the moreFlags field of the control record.
0831 BB34              *
0832 BB34              *
0833 BB34              * Inputs:
0834 BB34              *                   NewControlType  WORD
0835 BB34              *                   ControlHandle   LONG
0836 BB34              *
0837 BB34              * Outputs:
0838 BB34              *                   none
0839 BB34              *
0840 BB34              * External Refs:
0841 BB34                       import CMStartup 
0842 BB34                       import getCtlHand 
0843 BB34                       import get_long 
0844 BB34                       import isItSuper 
0845 BB34              *
0846 BB34              * Entry Points:
0847 BB34              *                   none
0848 BB34              *
0849 BB34                       longa on                       ; mode
0850 BB34                       longi on
0851 BB34              *
0852 BB34              ****************************************************************
0853 BB34              TheControl equ   Inputs
0854 BB34              NewFlags equ   TheControl+4
0855 BB34
0856 BB34 20 15 A0              jsr   CMStartup                Do tool function setup.
0857 BB37              ;
0858 BB37 20 9F A1              jsr   getCtlHand               ctlHand = passed control handle.
0859 BB3A              ;                                       ctlPtr = (ctlHand).
0860 BB3A A0 04 10              ldy   #NoCtlError
0861 BB3D B0 0F                 bcs   pop6                     Null handle passed?
0862 BB3F              ;
0863 BB3F 20 89 BB              jsr   IsItSuper
0864 BB42 B0 0A                 bcs   pop6
0865 BB44              ;
0866 BB44 A0 3C 00              ldy   #NewCtlRecord.CtlMoreFlags
0867 BB47              ;
0868 BB47 A5 52                 lda   <NewFlags
0869 BB49 97 05                 sta   [<Ctlptr],y
0870 BB4B              ;
0871 BB4B A0 00 00              ldy   #0                       No error flag.
0872 BB4E              ;
0873 BB4E              pop6      
0874 BB4E 82 2B E5              brl   CMpop6bytes
0875 BB51
0876 BB51                       ENDP 
0877 BB51
0878 BB51
0879 BB51                       title 'NotifyControls' 
0880 BB51              ****************************************************************
0881 BB51              *
0882 BB51              NotifyControls PROC EXPORT 
0883 BB51              *
0884 BB51              * For every super control in the control list whose
0885 BB51              * MoreFlags field ANDs with mask and is not zero, we
0886 BB51              * send the indicated message with the indicated param.
0887 BB51              *
0888 BB51              *
0889 BB51              ;   IN:  PUSH:WORD - MASK
0890 BB51              ;        PUSH:WORD - Message to Send
0891 BB51              ;        PUSH:LONG - Value for Param
0892 BB51              ;        PUSH:LONG - Pointer to Window
0893 BB51              ;        
0894 BB51              ;  OUT:  Nothing.
0895 BB51              ;
0896 BB51              *
0897 BB51              * External Refs:
0898 BB51                       import CMStartup 
0899 BB51                       import UseThisWindPtr 
0900 BB51                       import GetFirstSuperControl 
0901 BB51                       import GetNextSuperControl 
0902 BB51                       import Set2Draw 
0903 BB51                       import PushPort 
0904 BB51                       import Set2DrawCtl 
0905 BB51                       import ReadMoreFlags 
0906 BB51                       import CMDispatch 
0907 BB51                       import PopPort 
0908 BB51              *
0909 BB51              * Entry Points:
0910 BB51              *                   none
0911 BB51              *
0912 BB51                       longa on                       ; mode
0913 BB51                       longi on
0914 BB51              *
0915 BB51              * Change History
0916 BB51              *
0917 BB51              * 04 Nov 88         Steven Glass
0918 BB51              *
0919 BB51              * Added input to this routine so can notify controls that
0920 BB51              * are not in the front window.
0921 BB51              *
0922 BB51              * 17 Nov 88         Steven Glass
0923 BB51              *
0924 BB51              * Now use the specified window pointer instead of FrontWindow.
0925 BB51              *
0926 BB51              ****************************************************************
0927 BB51                       DSect Inputs 
0928 BB51              TheWindow long 
0929 BB51              TheParam long 
0930 BB51              TheMessage word 
0931 BB51              TheMask  word 
0932 BB51              ;
0933 BB51              ;
0934 BB51 20 15 A0              jsr   CMStartup                Do tool function setup.
0935 BB54
0936 BB54 A5 4E                 lda   TheWindow
0937 BB56 A6 50                 ldx   TheWindow+2
0938 BB58 20 BE BB              jsr   UseThisWindPtr
0939 BB5B B0 26                 bcs   exit
0940 BB5D
0941 BB5D 20 9C BB              jsr   GetFirstSuperControl
0942 BB60 B0 21                 bcs   exit
0943 BB62              ;
0944 BB62
0945 BB62 20 DF 96              jsr   set2draw                 Setup to draw standard controls.
0946 BB65 20 AF 9E              jsr   pushPort                 Save the current port.
0947 BB68 20 95 97              jsr   set2drawCtl              Setup to draw the control.
0948 BB6B
0949 BB6B
0950 BB6B              Loop      
0951 BB6B 20 32 A2              jsr   ReadMoreFlags
0952 BB6E 25 58                 and   TheMask
0953 BB70 F0 09                 beq   SkipThisOne
0954 BB72
0955 BB72 A5 52                 lda   <TheParam                Pass new view and data sizes.
0956 BB74 A4 54                 ldy   <TheParam+2
0957 BB76 A6 56                 ldx   <TheMessage              Task number.
0958 BB78 20 2B 9C              jsr   CMDispatch
0959 BB7B
0960 BB7B              SkipThisOne  
0961 BB7B 20 A6 BB              jsr   GetNextSuperControl
0962 BB7E 90 EB                 bcc   Loop
0963 BB80
0964 BB80 20 C9 9E              jsr   popPort                  Restore the current port.
0965 BB83              ;
0966 BB83 A0 00 00     exit     ldy   #0                       No error flag.
0967 BB86 82 02 E5              brl   CMpop12bytes
0968 BB89
0969 BB89                       ENDP 
0970 BB89
0971 BB89
0972 BB89
0973 BB89
0974 BB89
0975 BB89                       title 'IsItSuper' 
0976 BB89              ****************************************************************
0977 BB89              *
0978 BB89              IsItSuper PROC 
0979 BB89              *
0980 BB89              * This short routine returns whether or not the 
0981 BB89              * control in ctlHand/ctlPtr is a super control.
0982 BB89              *
0983 BB89              * If it is a super control, then y is zeroed and carry is 
0984 BB89              * clear.  If it is not, y is set to the NotSuperCtlError
0985 BB89              * and carry is set.
0986 BB89              *
0987 BB89              *
0988 BB89              *
0989 BB89              * Inputs:
0990 BB89              *                   CtlPtr
0991 BB89              *
0992 BB89              * Outputs:
0993 BB89              *                   carry
0994 BB89              *                   y-reg
0995 BB89              *
0996 BB89              * External Refs:
0997 BB89              *                   none
0998 BB89              *
0999 BB89              * Entry Points:
1000 BB89              *                   none
1001 BB89              *
1002 BB89                       longa on                       ; mode
1003 BB89                       longi on
1004 BB89              *
1005 BB89              ****************************************************************
1006 BB89
1007 BB89
1008 BB89 A0 16 00              ldy   #NewCtlRecord.CtlProc+2
1009 BB8C B7 05                 lda   [<CtlPtr],y
1010 BB8E 10 07                 bpl   Nope
1011 BB90
1012 BB90 A0 00 00              ldy   #0
1013 BB93 C0 01 00     Out      cpy   #1
1014 BB96 60                    rts   
1015 BB97
1016 BB97 A0 07 10     Nope     ldy   #NotSuperCtlError
1017 BB9A 80 F7                 bra   Out
1018 BB9C
1019 BB9C
1020 BB9C                       ENDP 
1021 BB9C
1022 BB9C
1023 BB9C
1024 BB9C                       title 'GetFirstSuperControl' 
1025 BB9C              ****************************************************************
1026 BB9C              *
1027 BB9C              GetFirstSuperControl PROC  
1028 BB9C              *
1029 BB9C              * Sets ctlHand and CtlPtr up with the first super control
1030 BB9C              * in the control list.
1031 BB9C              *
1032 BB9C              * Two errors can be returned:
1033 BB9C              *
1034 BB9C              *   NoCtlError
1035 BB9C              *   NoSuperCtlError
1036 BB9C              *
1037 BB9C              *
1038 BB9C              * Inputs:
1039 BB9C              *                   GetFirstCtl relys on Windptr being right
1040 BB9C              *
1041 BB9C              * Outputs:
1042 BB9C              *                   ctlHand & CtlPtr
1043 BB9C              *                   Carry   clear if there is one
1044 BB9C              *                           set if there is not
1045 BB9C              *                   y-reg   0 if no error
1046 BB9C              *                           error code otherwise
1047 BB9C              *
1048 BB9C              * External Refs:
1049 BB9C                       import GetFirstCtl 
1050 BB9C                       import IsItSuper 
1051 BB9C                       import next_Ctl 
1052 BB9C              *
1053 BB9C              * Entry Points:
1054 BB9C                       ENTRY GetNextSuperControl
1055 BB9C              *
1056 BB9C                       longa on                       ; mode
1057 BB9C                       longi on
1058 BB9C              *
1059 BB9C              ****************************************************************
1060 BB9C
1061 BB9C 20 93 A1              jsr   GetFirstCtl
1062 BB9F F0 18                 beq   NoControl
1063 BBA1 20 89 BB              jsr   IsItSuper
1064 BBA4 90 0A                 bcc   Done
1065 BBA6
1066 BBA6              ;-----------------------------------------------------------
1067 BBA6              ;
1068 BBA6              ; Secondary Entry for GetNextSuperControl
1069 BBA6              ;
1070 BBA6
1071 BBA6              GetNextSuperControl  
1072 BBA6
1073 BBA6 20 7C A3     Loop     jsr   Next_Ctl
1074 BBA9 F0 09                 beq   Nope
1075 BBAB 20 89 BB              jsr   IsItSuper
1076 BBAE B0 F6                 bcs   Loop
1077 BBB0
1078 BBB0 A0 00 00     Done     ldy   #0
1079 BBB3 60                    rts   
1080 BBB4
1081 BBB4 A0 05 10     Nope     ldy   #NoSuperCtlError
1082 BBB7 38                    sec   
1083 BBB8 60                    rts   
1084 BBB9
1085 BBB9 A0 04 10     NoControl ldy   #NoCtlError
1086 BBBC 38                    sec   
1087 BBBD 60                    rts   
1088 BBBE
1089 BBBE                       ENDP 
1090 BBBE
1091 BBBE                       title 'UseThisWindPtr' 
1092 BBBE              ****************************************************************
1093 BBBE              *
1094 BBBE              UseThisWindPtr PROC 
1095 BBBE              *
1096 BBBE              * This routine sets up the indicated window pointer for use.
1097 BBBE              * If the specified pointer is zero, we use the front window
1098 BBBE              * instead.
1099 BBBE              *
1100 BBBE              * Secondary entry point (UseFrontWindow works the same but
1101 BBBE              * does not check input registers, just calls frontwindow).
1102 BBBE              *
1103 BBBE              *
1104 BBBE              * Inputs:
1105 BBBE              *                   a-reg   low word of window ptr
1106 BBBE              *                   x-reg   high word of window ptr
1107 BBBE              *
1108 BBBE              * Outputs:
1109 BBBE              *                   carry   indicates error
1110 BBBE              *                   y-reg   has error if any
1111 BBBE              *                   windPtr (direct page) set for use
1112 BBBE              *
1113 BBBE              * External Refs:
1114 BBBE                       import makeWPtr 
1115 BBBE              *
1116 BBBE              * Entry Points:
1117 BBBE                       entry UseFrontWindow 
1118 BBBE              *
1119 BBBE                       longa on                       ; mode
1120 BBBE                       longi on
1121 BBBE              *
1122 BBBE              * Change History
1123 BBBE              *
1124 BBBE              * 21 Nov 88         Steven Glass
1125 BBBE              *
1126 BBBE              * Had a bne instead of beq to iszero on last test after
1127 BBBE              * front window call.
1128 BBBE              *
1129 BBBE              ****************************************************************
1130 BBBE
1131 BBBE
1132 BBBE 9B                    txy   
1133 BBBF D0 13                 bne   NotZero
1134 BBC1 A8                    tay   
1135 BBC2 D0 10                 bne   NotZero
1136 BBC4
1137 BBC4              UseFrontWindow  
1138 BBC4 48                    pha   
1139 BBC5 48                    pha   
1140 BBC6 A2 0E 15 22           _FrontWindow 
1141 BBCD 68                    pla   
1142 BBCE FA                    plx   
1143 BBCF
1144 BBCF
1145 BBCF D0 03                 bne   NotZero
1146 BBD1 A8                    tay   
1147 BBD2 F0 05                 beq   IsZero
1148 BBD4
1149 BBD4              NotZero   
1150 BBD4 20 C1 A1              jsr    makeWptr                ;windptr = pointer to window.
1151 BBD7 18                    clc   
1152 BBD8 60                    rts   
1153 BBD9
1154 BBD9              IsZero    
1155 BBD9 A0 0C 10              ldy   #NOWIND_Err
1156 BBDC 38                    sec   
1157 BBDD 60                    rts   
1158 BBDE
1159 BBDE                       ENDP 
1160 BBDE
1161 BBDE
1162 BBDE                       title 'ActiveGuts' 
1163 BBDE              ****************************************************************
1164 BBDE              *
1165 BBDE              ActiveGuts PROC 
1166 BBDE              *
1167 BBDE              * This routine finds the active super control in the window
1168 BBDE              * specified by WindowPtr. The result is returned in ctlHand 
1169 BBDE              * on direct page.
1170 BBDE              *
1171 BBDE              * If the control is not found, an error is returned in 
1172 BBDE              * the y-reg.  The y-reg is zero if all is ok.
1173 BBDE              *
1174 BBDE              * Possible errors are.
1175 BBDE              *
1176 BBDE              *   NOWIND_Err
1177 BBDE              *   NoCtlError
1178 BBDE              *   NoSuperCtlError
1179 BBDE              *   NoCtlActiveError
1180 BBDE              *
1181 BBDE              *
1182 BBDE              *
1183 BBDE              *
1184 BBDE              * Inputs:
1185 BBDE              *                   none
1186 BBDE              *
1187 BBDE              * Outputs:
1188 BBDE              *                   ControlHandle
1189 BBDE              *
1190 BBDE              * External Refs:
1191 BBDE                       import CMStartup 
1192 BBDE                       import GetFirstSuperControl 
1193 BBDE                       import GetNextSuperControl 
1194 BBDE                       import UseFrontWindow 
1195 BBDE              *
1196 BBDE              * Entry Points:
1197 BBDE                       ENTRY FindActiveGuts           ; (uses indicated window)
1198 BBDE                       ENTRY FindActiveGuts2          ; (uses frontwindow)
1199 BBDE              *
1200 BBDE                       longa on                       ; mode
1201 BBDE                       longi on
1202 BBDE              *
1203 BBDE              ****************************************************************
1204 BBDE
1205 BBDE
1206 BBDE              ResultH  equ   Inputs
1207 BBDE
1208 BBDE              FindActiveGuts2  
1209 BBDE 20 C4 BB              jsr   UseFrontWindow
1210 BBE1 B0 12                 bcs   exit
1211 BBE3
1212 BBE3              FindActiveGuts  
1213 BBE3 20 9C BB              jsr   GetFirstSuperControl
1214 BBE6 B0 0D                 bcs   exit
1215 BBE8
1216 BBE8
1217 BBE8 A0 3C 00     Loop     ldy   #NewCtlRecord.CtlMoreFlags
1218 BBEB B7 05                 lda   [<CtlPtr],y
1219 BBED 29 00 80              and   #FCtlActive
1220 BBF0 F0 07                 beq   NotThisOne
1221 BBF2
1222 BBF2
1223 BBF2 A0 00 00              ldy   #0                       ; no error
1224 BBF5 C0 01 00     exit     cpy   #1                       ; set carry correctly for error condition
1225 BBF8 60                    rts   
1226 BBF9
1227 BBF9 20 A6 BB     NotThisOne jsr   GetNextSuperControl
1228 BBFC 90 EA                 bcc   Loop
1229 BBFE
1230 BBFE A0 06 10              ldy   #noCtlActiveError
1231 BC01 80 F2                 bra   Exit
1232 BC03
1233 BC03
1234 BC03                       ENDP 
1235 BC03
1236 BC03
1237 BC03                       END   
